#!/bin/bash

# Get the screen width
screen_width=$(xrandr | awk '/ primary / {print $4}' | cut -d 'x' -f1)

# set width of dialog windows to 50% of the screen width
width=$(( screen_width * 50 / 100 ))


llang=$(echo $LANG | awk -F\_ '{print $1}')

if [ "$llang" = "de" ]; then
text_2="
<span size='x-large'>
Nach einem erfolgreichen Betatest stellen wir die Quellen für die von uns
ausgelieferte KDE-Software um. Nähere Informationen hierzu lesen Sie hier:

<a href='https://www.tuxedocomputers.com/de/Neues-ISO-Image-und-WebFAI-mit-neuen-Quellen-und-KDE-Plasma-6-5.tuxedo'> ISO Image und FAI mit neuen Quellen </a>

Die Aktualisierung auf die neuen Quellen erfolgt nicht automatisch durch die
Paketverwaltung (apt/Discover), sondern wird über ein eigens erstelltes Script
angestoßen. Eine Anleitung dazu finden Sie hier:

<a href='https://www.tuxedocomputers.com/de/Anleitung-zum-Umstellen-der-Quellen-bei-TUXEDO-OS.tuxedo'> Anleitung zur Aktualisierung.</a>
</span>
"
title_2="Systemmeldung - TUXEDO OS wechselt die Paketierung"
oklabel2="Jetzt aktualisieren"
cancellabel2="Später erinnern"
else
text_2="
<span size='x-large'>
After a successful beta test, we are changing the sources for the KDE software
supplied by us. You can read more about this here:

<a href='https://www.tuxedocomputers.com/en/New-ISO-image-and-WebFAI-with-new-sources-and-KDE-Plasma-6-5-3.tuxedo'> ISO Image and FAI with new sources </a>

The update to the new sources is not done automatically by the package
management (apt/Discover), but is triggered by a specially created script..
You can find instructions here:

<a href='https://www.tuxedocomputers.com/en/Instructions-for-switching-sources-with-TUXEDO-OS.tuxedo'> Update instructions</a>
</span>
"
title_2="System Message - TUXEDO OS changes package sources"
oklabel2="Upgrade now"
cancellabel2="Remind me later"
fi

if ! zenity --question --default-cancel --title "$title_2" --text "$text_2" --width "$width" --ok-label "$oklabel2" --cancel-label "$cancellabel2"  2>/dev/null; then
    exit 0
fi
/bin/bash /bin/2ustart.sh
