#!/bin/bash
# find used language
llang=$(echo "$LANG" | awk -F\_ '{print $1}')
logfile=/var/log/plasma-6-upgrade.log

# define and clear some variables
rm -f /tmp/checkroot
PASSWD=""

# Get the screen width
screen_width=$(xrandr | awk '/ primary / {print $4}' | cut -d 'x' -f1)

# set width of dialog windows to 50% of the screen width
width=$(( screen_width * 50 / 100 ))


# define text variables
case $llang in
        de)
            title_1="TUXEDO OS: Plasma Aktualisierung"
	    text_pass="Für die nachfolgenden Aktionen benötigen Sie Root-Rechte. Bitte geben Sie das Systemverwalter-Passwort ein."
	    text_inet="Keine Internetverbindung! Stellen Sie sicher, \ndass Sie mit dem Internet verbunden sind."
	    text_iso="Sie befinden sich in einer Live Sitzung der TUXEDO OS ISO, ein Plasma-Upgrade ist hier unmöglich. \n"
	    text_root="Keine Root Rechte erlangt, dieses Script benötigt Root-Rechte. \nDer aktuelle Benutzer ist nicht Mitglied der sudo Gruppe."
	    text_finish="Auf Ihrem System wurde die neue Plasma Version installiert, um die Aktualisierung abzuschließen, wird das System neu gestartet."
	    text_no_backup="Sie wählten Abbruch, sie können das Update jederzeit wieder starten."
	    text_abbruch="Aktualisierung durch Benutzer abgebrochen."
	    text_power="Das Gerät ist nicht an eine Stromquelle angeschlossen! Bitte schließen Sie das Gerät an eine Stromquelle an und widerholen Sie dann den Vorgang."
	    text_error="Aktualisierung nicht möglich, Abbruch an dieser Stelle, Details entnehmen Sie bitte dem Logfile \n\n<b>${logfile}</b>. \n\nWenn Sie Hilfe zur Problemlösung benötigen,  kontaktieren Sie unseren Technischen Kundenservice."
	    text_noneed="System ist schon auf umgestellt, beende."
	    text_release="Eine neue Version upgrader wurde installiert.\nDas Script muss neu gestartet werden."
            ;;
        *)
	    export LANG=C.UTF-8
	    title_1="TUXEDO OS: Plasma Upgrade"
	    text_pass="You need root rights for the following actions. Please enter the system administrator password."
	    text_inet="No internet connection! Please make sure that \nyou are connected to the Internet"
	    text_iso="You are in a live session of the TUXEDO OS ISO, a plasma upgrade is not possible here."
	    text_root="No root rights obtained, this script requires root rights. \nThe current user is not a member of the sudo group."
	    text_finish="Your system has been updated to the new LTS version. To complete the update, the system is restarted."
	    text_no_backup="You selected Cancel, you can restart the update at any time."
	    text_abbruch="Upgrade cancelled by user."
	    text_power="The device is not connected to a power source! Please connect the device to a power source and then repeat the process."
	    text_error="Upgrade not possible, cancellation at this point, Please refer to the log file \n\n<b>${logfile}</b>. \n\nfor details"
	    text_noneed="System is already switched to , exit."
	    text_release="A new version of upgrader has been installed.\nThe script must be restarted."
            ;;
esac

# check if the system is connected to internet
if ! wget -q --spider https://tuxedocomputers.com; then
    kdialog --error "$text_inet" --title "$title_1" 2>/dev/null
    echo "Keine Internetverbindung vorhanden"
    echo "1" > /tmp/retval
    exit 0
fi

# check, if the computer is connected to power suply
if [ "$(cat /sys/class/power_supply/AC0/online)" -eq "0" ]; then
    zenity --warning --text "<span size='x-large'>$text_power</span>" --title "$title_1" --width "$width" 2>/dev/null
    exit 1
fi

# check, if the system is a live medium of tuxedo os
if [ -d /fll ]; then
    kdialog --error "$text_iso" --title "$title_1" 2>/dev/null
    exit 0
fi

systemctl --user stop plasma-message.timer

# generate a big fat warningfor the user
if [ "$llang" = "de" ]; then
text_3="
<span size='x-large'>
Dieses Script wird Ihr System auf die neuen Quellen umstellen und aktualisieren.
Auch wenn unsere Tests und der Betatest erfolgreich waren, ist es angeraten, ein
Backup aller wichtigen Daten zu haben. Mit einem Klick auf Ja wird das System
aktualisiert und umgestellt.

Während der Aktualisierung sollten Sie nicht nebenher mit dem System weiterarbeiten,
da aktuell laufende Programme ihren Dienst versagen können.

<span color='red' size='xx-large'>Dieser Prozess darf nicht unterbrochen werden!</span>

Um mögliche Abstürze zu verhindern kann die Umstellung auch in einem Terminal
außerhalb der Plasma-Umgebung erfolgen. Dazu loggen Sie sich in einem TTY ein.
(Strg + Alt + F3) und führen <span color='green'>sudo upgrade.sh</span> aus.

Möchten Sie fortfahren?
</span>
"
title_3="Plasma Aktualisierung"
oklabel3="Ja"
cancellabel3="Nein"
else
text_3="
<span size='x-large'>
This script will switch your system to the new sources and perform the update.
Although our internal and beta tests were successful, we strongly recommend
creating a backup of all important data. By clicking Yes, the system will begin
the update and transition process..

During the upgrade, you should not continue working with the system, as programs 
currently running may fail.

<span size='xx-large' color='red'>Do not interrupt this process!</span>

To avoid potential crashes, the update can also be performed from a terminal
outside the Plasma session. To do so, log into a TTY (Ctrl + Alt + F3) and run:

<span color='green'>sudo upgrade.sh</span>

Do you want to proceed?
</span>
"
title_3="TUXEDO OS: Plasma Upgrade"
oklabel3="Yes"
cancellabel3="No"
fi

if zenity --question --default-cancel --title "$title_3" --text "$text_3" --width "$width" --ok-label "$oklabel3" --cancel-label "$cancellabel3"  2>/dev/null; then
    PASSWD=$(kdialog --password "$text_pass" --title "$title_1")
    if [ -z "$PASSWD" ]; then
	zenity --warning --text "<span size='large'>$text_root</span>" --title "$title_1" --width "$width" 2>/dev/null
	systemctl --user restart plasma-message.timer
	exit 1
    fi
    # Check sudo password before running the full command
    echo "$PASSWD" | sudo -SHE true
    SUDO_STATUS=$?

    if [ $SUDO_STATUS -ne 0 ]; then
	zenity --warning --text "<span size='large'>$text_root</span>" --title "$title_1" --width "$width" 2>/dev/null
	systemctl --user restart plasma-message.timer
	exit 1
    fi
    DISPLAY="$DISPLAY" XAUTHORITY="$XAUTHORITY" echo "$PASSWD" | sudo -SHE /bin/bash -c 'trap "exit" SIGINT; systemd-inhibit --what=idle:sleep /usr/bin/upgrade.sh'
    RET=$?
else
    zenity --info --text "<span size='x-large'>$text_no_backup</span>" --title "$title_1" 2>/dev/null
    systemctl --user restart plasma-message.timer
    exit 0
fi

if [ "$(cat /tmp/retval)" = "noneed" ]; then
    zeninty --info --text "$<span size='x-large'>text_noneed</span>" --title "$title_1" 2>/dev/null
    exit 0
fi

# cancel from user
if [ "$(cat /tmp/retval)" = "abbruch" ]; then
    zenity --warning --text "<span size='x-large'>$text_abbruch</span>" --title "$title_1" --width "$width" 2>/dev/null
    echo "$PASSWD" | sudo killall xterm
    exit 0
fi

if [ -f /tmp/release ]; then
    zenity --info --text "<span size='x-large'>$text_release</span>" --title "$title_1" --width "$width" 2>/dev/null
    echo "$PASSWD" | sudo killall xterm
    exit 0
fi

# upgrade 100 % successfull
if [ "$RET" -eq 0 ]; then
    zenity --info --text "<span color='green' size='x-large'>$text_finish</span>" --title "$title_1" --width "$width" 2>/dev/null
    rm -rf ~/.cache
    rm -f ~/.config/*.lock
    rm -f ~/.config/systemd/user/timers.target.wants/plasma-message.timer
    rm -f ~/.config/systemd/user/plasma-upgrade.service
    rm -f ~/-local/share/timers/stamp-plasma-message.timer
    systemctl reboot
else
    zenity --info --text "<span size='x-large'>$text_error</span>" --title "$title_1" --width "$width" 2>/dev/null
fi
