#!/bin/bash
# find used language
llang=$(echo "$LANG" | awk -F\_ '{print $1}')

# Pfad zur Zählerdatei
COUNTER_FILE="$HOME/script_counter"

# define and clear some variables
rm -f /tmp/checkroot
PASSWD=""
logfile="/var/log/tuxedo-upgrade/upgrade.log"

# resete screen scaling
#export GDK_DPI_SCALE=1
#export QT_SCALE_FACTOR=1

# Get the screen width
screen_width=$(xrandr | awk '/ primary / {print $4}' | cut -d 'x' -f1)

# set width of dialog windows to 50% of the screen width
width=$(( screen_width * 50 / 100 ))

# hidpi settings
#if [ "$screen_width" -ge "3800" ]; then
#    export GDK_DPI_SCALE=1.5
#    export QT_SCALE_FACTOR=1.5
#elif [ "$screen_width" -ge "2048" ]; then
#    export GDK_DPI_SCALE=1.25
#    export QT_SCALE_FACTOR=1.25
#fi

# get the values of free space on / and /boot and set the required minimum
required_space_sys=$((6 * 1024 * 1024))
available_space_sys=$(df --output=avail / | tail -n1)
space_sys=$(echo "$available_space_sys"/1024/1024|bc)
if findmnt -rn -o TARGET /boot | grep -q '^/boot$'; then
    touch /tmp/bootpart
    required_space_boot=$((150 * 1024 ))
    available_space_boot=$(df --output=avail /boot | tail -n1)
    space_boot=$(echo "$available_space_boot"/1024|bc)
    
else
    rm -f /tmp/bootpart
fi


# define text variables
case $llang in
        de)
            title_1="TUXEDO OS: System Aktualisierung"
	    text_release="Eine neue Version tuxedo-release-upgrade wurde installiert.\nDas Script muss neu gestartet werden."
	    text_pass="Für die nachfolgenden Aktionen benötigen Sie Root-Rechte. Bitte geben Sie das Systemverwalter-Passwort ein."
	    text_inet="Keine Internetverbindung! Stellen Sie sicher, \ndass Sie mit dem Internet verbunden sind."
	    text_iso="Sie befinden sich in einer Live Sitzung der TUXEDO OS ISO, ein Plasma-Upgrade ist hier unmöglich. \n"
	    text_error="Aktualisierung nicht möglich, Abbruch an dieser Stelle, Details entnehmen Sie bitte dem Logfile \n\n<b>${logfile}</b>. \n\nWenn Sie hilfe zur Problemlösung benötigen,  kontaktieren Sie unseren Technischen Kundenservice."
	    text_error2="Die System Aktualisierung war nicht erfolgreich. Ihr System ist nun vermutlich in einem unbootbaren Zustand. \nDetails entnehmen Sie bitte dem Logfile <b>${logfile}</b>. \n\nDer schnellste und einfachste Weg für Sie ist eine Neuinstallation. Im Zweifelsfall kontaktieren Sie unseren Technischen Kundenservice."
	    text_root="Keine Root Rechte erlangt, dieses Script benötigt Root-Rechte. \nDer aktuelle Benutzer ist nicht Mitglied der sudo Gruppe."
	    text_finish="Ihr System wurde auf die neue LTS Version aktualisiert, um die Aktualisierung abzuschließen, wird das System neu gestartet."
	    text_finish_error1="Ihr System wurde auf die neue LTS Version aktualisiert. \n"
	    text_finish_error2="Auf Grund von installierten Drittanbieter-Paketen konnten einige Pakete nicht installiert/aktualisiert werden."
	    text_finish_error3="Um die Aktualisierung abzuschließen, wird das System neu gestartet. \n"
	    text_finish_error4="Für mehr Details schauen Sie bitte in das Logfile <b>${logfile}</b> der Aktualisierung. \n"
	    text_no_backup="Sie haben kein aktuelles Backup, die Aktualisierung wird nicht ausgeführt."
	    text_abbruch="Aktualisierung durch Benutzer abgebrochen."
	    text_power="Das Gerät ist nicht an eine Stromquelle angeschlossen! Bitte schließen Sie das Gerät an eine Stromquelle an und widerholen Sie dann den Vorgang."
	    text_bootspace="Ihre Bootpartition hat ${space_boot} MiB freien Speicher, für diese Aktualisierung benötigen Sie \nmindestens 150 MiB verfügbaren Speicherplatz in /boot. Bitte deinstallieren sie vor der \nAktualisierung nicht benötigte Kernel <b>(sudo apt-get purge linux-image-..)</b>.\n\nBeende Script."
	    text_sysspace="Ihre Systempartition hat ${space_sys} GiB freien Speicher, für diese Aktualisierung benötigen Sie mindestens 6 GiB verfügbaren \nSpeicherpatz auf Ihrer Systempartition. Bitte deinstallieren Sie nicht benötigte Pakete <b>(sudo apt-get purge [package])</b> \nund/oder leeren Sie den apt-Cache <b>(apt-get clean)</b> um den benötigten Speicherplatz zu erhalten.\n\nBeende Script."
            ;;
        *)
	    export LANG=C.UTF-8
	    title_1="TUXEDO OS: System Upgrade"
	    text_release="A new version of tuxedo-release-upgrade has been installed.\nThe script must be restarted."
	    text_pass="You need root rights for the following actions. Please enter the system administrator password."
	    text_inet="No internet connection! Please make sure that \nyou are connected to the Internet"
	    text_iso="You are in a live session of the TUXEDO OS ISO, a plasma upgrade is not possible here."
	    text_error="Upgrade not possible, cancellation at this point, Please refer to the log file \n\n<b>${logfile}</b>. \n\nfor details"
	    text_error2="The system upgrade was not successful. Your system is now probably in an unbootable state. \nPlease refer to the log file <b>${logfile}</b> for details. \n\nThe quickest and easiest way for you is a new installation. If in doubt, please contact our technical customer service."
	    text_root="No root rights obtained, this script requires root rights. \nThe current user is not a member of the sudo group."
	    text_finish="Your system has been updated to the new LTS version. To complete the update, the system is restarted."
	    text_finish_error1="Your system has been updated to the new LTS version. \n"
	    text_finish_error2="Due to installed third-party packages, some packages could not be installed/updated."
	    text_finish_error3="To complete the update, the system is restarted. \n"
	    text_finish_error4="For more details, please refer to the log file <b>${logfile}</b> of the upgrade. \n"
	    text_no_backup="You do not have a current backup, the upgrade will not be executed."
	    text_abbruch="Upgrade cancelled by user."
	    text_power="The device is not connected to a power source! Please connect the device to a power source and then repeat the process."
	    text_bootspace="Your boot partition has ${space_boot} MiB free space, for this upgrade you need at least 150 MiB available space \nin /boot. Please purge unneeded kernel <b>(sudo apt-get purge [linux-image-...])</b>.\n\nExit Script."
	    text_sysspace="Your system partition has ${space_sys} GiB of free space, for this upgrade you need at least 6 GiB of available space \non your system partition. Please purge unneeded packages <b>(sudo apt-get purge [package])</b> and/or clear \nthe apt cache <b>(sudo apt-get clean)</b> to get the required space.\n\nExit Script."
            ;;
esac

# check if the system is connected to internet
if ! wget -q --spider https://tuxedocomputers.com; then
    kdialog --error "$text_inet" --title "$title_1" 2>/dev/null
    echo "Keine Internetverbindung vorhanden"
    echo "1" > /tmp/retval
    exit 0
fi

# check, if the computer is connected to power suply
if [ "$(cat /sys/class/power_supply/AC0/online)" -eq "0" ]; then
    zenity --warning --text "<span size='x-large'>$text_power</span>" --title "$title_1" --width "$width" 2>/dev/null
    exit 1
fi

# check, if the system is a live medium of tuxedo os
if [ -d /fll ]; then
    kdialog --error "$text_iso" --title "$title_1" 2>/dev/null
    exit 0
fi

# check required free space on /boot for upgrade
if [ -f /tmp/bootpart ]; then
    if (( available_space_boot < required_space_boot )); then
	zenity --warning --title "$title_1" --width "$width" --text "$text_bootspace"
	exit 1
    fi
fi    

# check the required space on / for upgrade
if (( available_space_sys < required_space_sys )); then
    zenity --warning --title "$title_1" --width "$width" --text "$text_sysspace"
    exit 1
fi

# generate a big fat warningfor the user
if [ "$llang" = "de" ]; then
    url="https://www.tuxedocomputers.com/de/Anleitung-zum-Upgrade-auf-TUXEDO-OS-Basis.tuxedo"
    zenity --question --default-cancel --title "$title_1" --width "$width" --text \
"<span color='red' size='xx-large'><b>                                                                  Achtung</b></span>
<span color='red' size='x-large'>
Beim Upgrade von Ubuntu 22.04 auf 24.04 gab es einige schwerwiegende Probleme. <u><b>Deshalb ist es dringend
anzuraten, ein Backup wichtiger Daten zu erstellen</b></u>, bevor Sie das Update starten. Zudem müssen Sie im
Nachgang einige Anpassungen vornehmen, auf die wir Sie hiermit aufmerksam machen.\n</span>
<span size='x-large'>Risiken bei der Aktualisierung:</span>
<span size='x-large'>
    * Datenverlust: Es wird dringend empfohlen, ein vollständiges Backup zu erstellen.
    * Verlust von Einstellungen und Anpassungen: Systemanpassungen können überschrieben werden.
    * Inkompatible Software: Einige Anwendungen könnten nach dem Upgrade nicht mehr funktionieren oder fehlen.
    * Treiberprobleme: Hardwaretreiber könnten nach dem Upgrade nicht mehr kompatibel sein.
    * Drittanbieter-Software: Einige Programme oder Bibliotheken könnten nicht mehr verfügbar sein.
    <b>* Ein Downgrade auf die vorherige TUXEDO OS Basis ist nicht möglich.</b>
</span>
<span color='red' size='x-large'>Alle Software-Quellen aus dritter Hand werden deaktiviert. Alte Source-Einträge werden in </span><span size='x-large' color='green'><b>/etc/apt/backup/* </b></span><span color='red' size='x-large'>gesichert.\n</span>
<span size='x-large'>Unter <b>$url</b> finden Sie \neine Anleitung zur Aktualisierung.\n</span>
<span size='x-large'>Backup vorhanden?</span>" 2>/dev/null
else
    url="https://www.tuxedocomputers.com/en/Howto-for-the-Upgrade-of-the-TUXEDO-OS-Base.tuxedo"
    zenity --question --default-cancel --title "$title_1" --width "$width" --text \
"<span color='red' size='xx-large'><b>                                                                  Please note</b></span>
<span color='red' size='x-large'>
When upgrading from Ubuntu 22.04 to 24.04 there were some serious problems. <u><b>It is therefore strongly
recommended that you create a backup of important data</b></u> before you start the update. You will also need to
make some adjustments afterwards, which we would like to draw your attention to.
</span>
<span size='x-large'>Risks associated with upgrading:</span>
<span size='x-large'>
    * Data loss: It is highly recommended to create a complete backup before proceeding.
    * Loss of settings and customizations: System modifications may be overwritten during the upgrade.
    * Incompatible software: Some applications might not work or may be missing after the upgrade.
    * Driver issues: Hardware drivers may become incompatible after the upgrade.
    * Third-party software: Some programs or libraries may no longer be available.
    <b>* A downgrade to the previous TUXEDO OS basis is not possible.</b>
</span>
<span color='red' size='x-large'>This script will deactivate all third-party repositories. Old source entries will be backed up under </span><span size='x-large' color='green'><b>/etc/apt/backup/* </b></span><span color='red' size='x-large'>.\n</span>
<span size='x-large'>Under <b>$url</b> you will find\ninstructions for upgrading.\n</span>
<span size='x-large'>Do you have a backup ready?\n\n</span>" 2>/dev/null
fi

if [ $? -eq 0 ]; then
    PASSWD=$(kdialog --password "$text_pass" --title "$title_1")
    if [ -z "$PASSWD" ]; then
        zenity --warning --text "<span size='large'>$text_root</span>" --title "$title_1" --width "$width" 2>/dev/null
        exit 1
    fi

    # Check sudo password before running the full command (robust mit printf)
    printf '%s\n' "$PASSWD" | sudo -S -p '' true
    SUDO_STATUS=$?

    if [ $SUDO_STATUS -ne 0 ]; then
        zenity --warning --text "<span size='large'>$text_root</span>" --title "$title_1" --width "$width" 2>/dev/null
        # Passwort löschen
        PASSWD=
        unset PASSWD
        exit 1
    fi

    # Nun den eigentlichen Befehl starten.
    # Wir übergeben DISPLAY/XAUTHORITY explizit an sudo (besser als nur -E)
    # und verwenden printf statt echo.
    printf '%s\n' "$PASSWD" | sudo -S --preserve-env=DISPLAY,XAUTHORITY -H /bin/bash -c \
      'trap "exit" SIGINT; systemd-inhibit --what=idle:sleep /usr/bin/1tuxedo-release-upgrade'

    # Aufräumen: Passwort aus dem Shell-Environment entfernen
    PASSWD=
    unset PASSWD
else
    kdialog --msgbox "$text_no_backup"
    exit 0
fi

# if a new version of tuxedo-release-upgrade is installed during upgrade, stop the script
if [ -f /tmp/release ]; then
    zenity --info --text "<span size='x-large'>$text_release</span>" --title "$title_1" --width "$width" 2>/dev/null
    echo "$PASSWD" | sudo killall xterm
    exit 0
fi

# cancel from user
if [ "$(cat /tmp/retval)" = "abbruch" ]; then
    zenity --warning --text "<span size='x-large'>$text_abbruch</span>" --title "$title_1" --width "$width" 2>/dev/null
    echo "$PASSWD" | sudo killall xterm
    exit 0
fi

# cancel on error, system should be fine
if [ "$(cat /tmp/retval)" = "error" ]; then
    zenity --warning --text "<span size='x-large'>$text_error</span>" --title "$title_1" --width "$width" 2>/dev/null
    echo "$PASSWD" | sudo killall xterm
    exit 1
fi

# cancel on error in real bad state of the script, system is presumably unbootable
if [ "$(cat /tmp/retval)" = "uerror" ]; then
    zenity --warning --text "<span size='x-large'>$text_error2</span>" --title "$title_1" --width "$width" 2>/dev/null
    echo "$PASSWD" | sudo killall xterm
    exit 1
fi

# upgrade successfull, but some packages are not upgrades
if [ "$(cat /tmp/retval)" -eq 0 ] && [ -f /tmp/retval1 ]; then
    zenity --info --title "$title_1" --width "$width" --text \
"<span size='x-large' color='green'>$text_finish_error1</span>
<span size='x-large' color='red'><b>$text_finish_error2</b></span>
<span size='large'>$text_finish_error4</span>
<span size='x-large' color='green'>$text_finish_error3</span>" 2>/dev/null
    lookandfeeltool -a org.tuxedotwilight.desktop
    printf "[KSplash]\nTheme=org.tuxedo.desktop\n" > ~/.config/ksplashrc
    sleep 3
    rm -rf ~/.cache
    rm -f ~/.config/*.lock
    systemctl reboot
fi

# upgrade 100 % successfull
if [ "$(cat /tmp/retval)" -eq 0 ] && [ ! -f /tmp/retval1 ]; then
    zenity --info --text "<span color='green' size='x-large'>$text_finish</span>" --title "$title_1" --width "$width" 2>/dev/null
    lookandfeeltool -a org.tuxedotwilight.desktop
    printf "[KSplash]\nTheme=org.tuxedo.desktop\n" > ~/.config/ksplashrc
    sleep 3
    rm -rf ~/.cache
    rm -f ~/.config/*.lock
    rm -f $HOME/$COUNTER_FILE
    systemctl reboot
fi
echo "$PASSWD" | sudo killall -9 xterm
exit 0
