#!/bin/bash

llang=$(echo $LANG | awk -F\_ '{print $1}')
logfile=$HOME/.upgrader.log

case $llang in
	de)
	    text_1="Für TUXEDO OS ist eine Systemaktualisierung verfügbar.<br> \
                    Drittanbieter-Pakete, welche nicht kompatibel zu TUXEDO OS mit Basis 24.04 sind, können bei diesem <br> \
                    Vorgang Probleme bereiten und die Installation oder Aktualisierung von Paketen aus den offizellen <br> \
                    Quellen verhindern. <br><br> \
                    <font color='red'>Es ist ratsam, alle Drittanbieter Pakete vor der Aktualisierung zu entfernen.</font><br><br> \
                    Um das Upgrade zu starten, klicken Sie bitte auf das entsprechende Icon auf ihrem Desktop.<br>"
	    title_1="TUXEDO OS: System Upgrade"
	    ;;
	*)
	    export LANG=C.UTF-8
	    text_1="A system update is available for TUXEDO OS. <br> \
                    Third-party packages that are not compatible with TUXEDO OS with base 24.04 can cause problems during <br> \
                    this process and prevent the installation or update of packages from the official sources. <br><br> \
                    <font color='red'>It is advisable to remove all third-party packages before upgrading.</font><br><br> \
                    To start the upgrade, please click on the corresponding icon on your desktop.<br>"
	    title_1="TUXEDO OS: System Upgrade"
	    ;;
esac

show_message() {
    kdialog --msgbox "<p>$text_1</p>" --title "$title_1" 2>/dev/null
}

sleep 3
show_message
exit 0