#!/bin/bash

llang=$(echo $LANG | awk -F\_ '{print $1}')

case $llang in
	de)
	    text_1="<H1>Unterstützung für TUXEDO OS 2 und 3 beendet</H1><br> \
<font size='4'>Die Unterstützung für TUXEDO OS 2 und 3 ist ausgelaufen. <br> \
Ihr System bleibt zwar funktionsfähig, aber Sie erhalten keine Aktualisierungen und Sicherheitsupdates<br> \
aus den zusätzlichen Quellen von TUXEDO OS oder Plasma mehr.<br><br> \
Bitte führen Sie daher zeitnah ein Upgrade auf die neueste Version von TUXEDO OS durch.<br> \
Eine Anleitung dazu finden Sie hier: <br><br>https://www.tuxedo.de/de/Anleitung-zum-Upgrade-auf-TUXEDO-OS-Basis.tuxedo</font><br><br> \
<br>"
	    title_1="Systemmeldung - Support-Ende für TUXEDO OS 2 und 3"
	    ja="Jetzt aktualisieren"
	    nein="Später erinnern"
	    ;;
	*)
	    export LANG=C.UTF-8
	    text_1="<H1>Support for TUXEDO OS 2 and 3 has ended</H1><br> \
<font size='4'>Support for TUXEDO OS 2 and 3 has been discontinued.<br> \
Your system will remain functional, but you will no longer receive updates and <br> \
security updates from the additional sources of TUXEDO OS or Plasma.<br><br> \
Please upgrade to the latest version of TUXEDO OS as soon as possible.<br> \
You can find instructions on how to do this here: <br><br>https://www.tuxedo.de/en/Howto-for-the-Upgrade-of-the-TUXEDO-OS-Base.tuxedo</font><br><br> \
<br>"
	    title_1="System message - End of support for TUXEDO OS 2 and 3"
	    ja="Update now"
	    nein="Remind me later"
	    ;;
esac

# Pfad zur Zählerdatei
COUNTER_FILE="$HOME/script_counter"

# Initialisiere den Zähler, falls die Datei nicht existiert
if [ ! -f "$COUNTER_FILE" ]; then
    echo "0" > "$COUNTER_FILE"
fi

# Lese den aktuellen Zählerstand
COUNTER=$(<"$COUNTER_FILE")

# Erhöhe den Zähler
((COUNTER++))

# Speichere den neuen Zählerstand
echo "$COUNTER" > "$COUNTER_FILE"

# Führe die Aktion nur bei jedem 5. Aufruf aus
if [ $((COUNTER % 2)) -eq 0 ]; then
    echo "0" > "$COUNTER_FILE"
    if ! kdialog --warningyesno "<p>$text_1</p>" --title "$title_1" --yes-label "$ja" --no-label "$nein" 2>/dev/null; then
	exit 0
    fi
/bin/bash /bin/1ustart.sh
fi
