#!/bin/bash

tomte=""
logfile=/var/log/fix-upgrade.log

echo "Starting update at: $(date)" > "$logfile"
echo "" >> "$logfile"
echo "--------------------------------------" >> "$logfile"
echo "" >> "$logfile"

rm -f /tmp/retval
rm -f /tmp/release

if ! wget -q --spider https://tuxedocomputers.com; then
    echo "No network" | tee -a "$logfile"
    exit 1
fi

if dpkg -l | grep -q tomte; then
    tomte="tuxedo-tomte"
fi

if grep -q "http://" /etc/apt/sources.list.d/*.sources; then
    http="1"
else
    http=""
fi

llang=$(echo "$LANG" | awk -F\_ '{print $1}')

if [ "$EUID" -ne 0 ]; then
    if [ "$llang" = "de" ]; then
	echo "Das Script muss als Root ausgeführt werden" | tee -a "$logfile"
    else
	echo "You need to run this script as root!" | tee -a "$logfile"
    fi
    exit 1
fi

dpkg --purge tuxedo-webfai-nb-grub tuxedo-webfai-desktop-grub tuxedo-release-upgrade

if dpkg -l | grep -q kdepim-addons; then
    pimaddons="1"
else
    pimaddons="0"
fi

rm -rf /etc/apt/apt.conf.d/99*
rm -rf /etc/apt/apt.conf.d/98*

if [ "$llang" = "de" ]; then
    echo "Kopiere neue Apt Sourcen und Preferences" | tee -a "$logfile"
else
    echo "Copy new apt sources and preferences" | tee -a "$logfile"
fi
cp -af /usr/share/tuxedo/upgrade-fix/30-* /etc/apt/preferences.d/ | tee -a "$logfile"
if [ ! -f /usr/bin/snap ]; then
    cp -af /usr/share/tuxedo/upgrade-fix/10-* /etc/apt/preferences.d/ | tee -a "$logfile"
fi
if [ "$http" = "1" ]; then
    sed -i "s|https:|http:|" /etc/apt/sources.list.d/tuxedo-os-plasma.sources
fi
cp -af /usr/share/tuxedo/upgrade-fix/9*-* /etc/apt/apt.conf.d/ | tee -a "$logfile"
echo ""

if [ "$llang" = "de" ]; then
    echo "Aktualisiere Paketquellen" | tee -a "$logfile"
else
    echo "Update package sources" | tee -a "$logfile"
fi

if LANG=C apt-get update 2>&1 | tee -a "$logfile" | grep -Eq '^Err:|^W:'; then
    echo "❌ problem with apt-get update" | tee -a "$logfile"
    systemctl unmask packagekit
    exit 1
fi
echo "Full-Upgrade download only" | tee -a "$logfile"
DEBIAN_FRONTEND=noninteractive apt-get --allow-downgrades --download-only --assume-yes  dist-upgrade 2>&1 | tee -a "$logfile"
ret=${PIPESTATUS[0]}
if [ "$ret" -ne 0 ]; then
    echo "❌ apt-get dist-upgrade download only failed (Exit $ret)" | tee -a "$logfile"
    systemctl unmask packagekit
    exit $ret
fi
echo "dist-upgrade simulation"  | tee -a "$logfile"
DEBIAN_FRONTEND=noninteractive apt-get --allow-downgrades --assume-yes -o dpkg::options::="--force-confold" -o dpkg::options::="--force-confold" dist-upgrade -s 2>&1 | tee -a "$logfile"
ret=${PIPESTATUS[0]}
if [ "$ret" -ne 0 ]; then
    echo "❌ simulation of apt-get dist-upgrade download only failed (Exit $ret)" | tee -a "$logfile"
    systemctl unmask packagekit
    exit $ret
fi
echo "Full-Upgrade really" | tee -a "$logfile"
DEBIAN_FRONTEND=noninteractive apt-get --allow-downgrades --assume-yes -o dpkg::options::="--force-confold" -o dpkg::options::="--force-confold" dist-upgrade 2>&1 | tee -a "$logfile"
ret=${PIPESTATUS[0]}
if [ "$ret" -ne 0 ]; then
    echo "❌ apt-get dist-upgrade failed (Exit $ret). Needs manual fixing." | tee -a "$logfile"
    systemctl unmask packagekit
    exit $ret
fi
apt-mark showauto > /tmp/auto.txt
echo "Remove Neon packages" | tee -a "$logfile"
DEBIAN_FRONTEND=noninteractive apt-get -y purge $(dpkg -l | grep  -E "\+neon|vrelease|release\+" | awk '{print $2}') 2>&1 | tee -a "$logfile"

if [ "$llang" = "de" ]; then
    echo "Repariere die entfernten libs" | tee -a "$logfile"
else
    echo "Fix for missing Libs" | tee -a "$logfile"
fi
DEBIAN_FRONTEND=noninteractive apt-get --assume-yes -o dpkg::options::="--force-confold" -o dpkg::options::="--force-confold" --reinstall install $(dpkg -l | grep -E "~tux1|~tux2" | awk '{print $2}') plasma-desktop tuxedoos-desktop language-selector-common 2>&1 | tee -a "$logfile"
ret=${PIPESTATUS[0]}
if [ "$ret" -ne 0 ]; then
    echo "That reinstall with dpkg -l was failing, use packagelist instead" | tee -a "$logfile"
    echo "2nd try with packagelist" | tee -a "$logfile"
    DEBIAN_FRONTEND=noninteractive apt-get --assume-yes -o dpkg::options::="--force-confold" -o dpkg::options::="--force-confold" --reinstall install $(</usr/share/tuxedo/upgrader/packagelist.txt) plasma-desktop tuxedoos-desktop language-selector-common 2>&1 | tee -a "$logfile"
fi

if [ "$llang" = "de" ]; then
    echo "Erzeuge Liste automatisch installierter Pakete" | tee -a "$logfile"
else
    echo "Create list of automaticly installed packages" | tee -a "$logfile"
fi
apt-mark auto $(</tmp/auto.txt)

if [ "$pimaddons" = "1" ]; then
    DEBIAN_FRONTEND=noninteractive apt-get --assume-yes --allow-downgrades install kdepim-addons 2>&1 | tee -a "$logfile"
fi

if [ "$llang" = "de" ]; then
    echo "Reaktiviere Packagekit" | tee -a "$logfile"
else
    echo "Reenable packagekit" | tee -a "$logfile"
fi
echo "systemctl unmask packagekit" | tee -a "$logfile"
systemctl unmask packagekit | tee -a "$logfile"

echo "DEBIAN_FRONTEND=noninteractive apt-get -y purge upgrader" | tee -a "$logfile"
DEBIAN_FRONTEND=noninteractive apt-get -y purge upgrader 2>&1 | tee -a "$logfile"
echo "DEBIAN_FRONTEND=noninteractive apt-get -y install tuxedo-control-center" | tee -a "$logfile"
DEBIAN_FRONTEND=noninteractive apt-get -y install tuxedo-control-center sddm-theme-breeze 2>&1 | tee -a "$logfile"
echo "DEBIAN_FRONTEND=noninteractive apt-get -y install --no-install-recommends tuxedo-base-files tuxedo-common-settings" | tee -a "$logfile"
DEBIAN_FRONTEND=noninteractive apt-get -y install --no-install-recommends tuxedo-base-files tuxedo-common-settings tuxedo-webfai-grub "$tomte" 2>&1 | tee -a "$logfile"

echo "Set sddm theme to default tuxedo" | tee -a "$logfile"
sed -i 's/^Current=.*/Current=tuxedo/' /etc/sddm.conf.d/kde_settings.conf | tee -a "$logfile"
echo "rm -f /etc/apt/preferences.d/30-*" | tee -a "$logfile"
rm -f /etc/apt/preferences.d/30-*
rm -f /etc/apt/sources.list.d/tuxedo-os-plasma.sources.bak
echo "Das Upgrade wurde erfolgreich beendet. ||  The upgrade went through successfuly." | tee -a "$logfile"
echo "Das System muss neu gestartet werden.  ||  The system needs to be rebooted." | tee -a "$logfile"

if [ -n "$DISPLAY" ] || [ -n "$WAYLAND_DISPLAY" ]; then
    if ! ps aux | grep 2ustart | grep -vq grep; then
	zenity --info --text "<span color='green' size='x-large'>Aktualisierung erfolgreich beendet. System muss neu gestartet werden.\n\nUpgrade successfuly. System needs to be rebooted.</span>" --width "700" 2>/dev/null
	systemctl reboot
    else
	exit 0
    fi
else
    if [ "$llang" = "de" ]; then
	echo "Das Upgrade wurde erfolgreich beendet. Das system muss nun neu gestartet werden." | tee -a "$logfile"
	read -p "Enter"
	rm -rf /home/*/.cache | tee -a "$logfile"
	systemctl reboot
    else
	echo "The upgrade went through successfuly. The system needs to be rebooted." | tee -a "$logfile"
	read -p "Enter"
	rm -rf /home/*/.cache | tee -a "$logfile"
	systemctl reboot
    fi
fi
