#!/usr/bin/env python3
# -*- coding: utf-8 -*-
#
# === This file is part of Calamares - <http://github.com/calamares> ===
#
#   Copyright 2014, Philip Müller <philm@manjaro.org>
#
#   Calamares is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   (at your option) any later version.
#
#   Calamares is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with Calamares. If not, see <http://www.gnu.org/licenses/>.

import time
import libcalamares
import os
import subprocess
import gettext
_ = gettext.translation("calamares-tuxedo",
                        localedir=libcalamares.utils.gettext_path(),
                        languages=libcalamares.utils.gettext_languages(),
                        fallback=True).gettext

def pretty_name():
    return _("Umount live system from Calamares install-rootfs.")

def run():
    """ Umount live system from Calamares install-rootfs.
        Generate a / mount point for fll based live systems
        and mount bind the live system there
    """
    path = "/tmp/calamares"
    if  os.path.exists( path ):
        if os.path.ismount( path ):
            subprocess.Popen( ["umount", path] )
            time.sleep( .300 )
            os.rmdir( path )
