#!/usr/bin/env python3
# -*- coding: utf-8 -*-
#
# === This file is part of Calamares - <http://github.com/calamares> ===
#
#   Copyright 2014, Philip Müller <philm@manjaro.org>
#
#   Calamares is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   (at your option) any later version.
#
#   Calamares is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with Calamares. If not, see <http://www.gnu.org/licenses/>.

import glob
import libcalamares
import os
import subprocess
import psutil
import gettext
_ = gettext.translation("calamares-tuxedo",
                        localedir=libcalamares.utils.gettext_path(),
                        languages=libcalamares.utils.gettext_languages(),
                        fallback=True).gettext

def pretty_name():
    return _("Waiting for propably running tomte process and mount /, if tomte has finished.")

def checkIfProcessRunning(processName):
    for proc in psutil.process_iter():
         try:
            if processName.lower() in proc.name().lower():
                return True
         except (psutil.NoSuchProcess, psutil.AccessDenied, psutil.ZombieProcess):
            pass
    return False;

def run():
    """ Waiting for propably running tomte process and mount /, if tomte has finished.
        Generate a / mount point for fll based live systems
        and mount bind the live system there
    """
    while(checkIfProcessRunning('tuxedo-tomte')):
        continue

    path = "/tmp/calamares"
    if not os.path.exists( path ):
        os.mkdir(path)
        subprocess.Popen(["mount", "--bind", "/", path])

