#!/bin/bash

# Dieses Script installiert das System mit LUKS Voll-Verschlüsselung auf eine, vom User ausgewählte Festplatte.
# Wenn die Abfrage nach der Verschlüsselung verneint wird, startet Calamares ganz normal.

set -euo pipefail
IFS=$'\n\t'

if [ "$EUID" -ne 0 ]
  then echo "Please run as root"
  exit
fi

crypt=""
efi=""
space=""
partcount=""
fastboot=""
bitlock=""
rm -f /tmp/fastboot
rm -f /tmp/bitlock
rm -f /tmp/detail.txt
rm -f /tmp/device
rm -f /tmp/device1
rm -f /tmp/mounts
rm -f /tmp/sizes
rm -f /tmp/ventoy
rm -f /root/crypt
rm -f /root/boot
rm -f /root/efi
rm -f /root/disk


systemctl stop tuxedo-tomte.timer
killall -9 tuxedo-tomte || true

logfile=/var/log/tux-install-log
rm -f "$logfile"

# prüfe ob Windows mit fastboot beendet wurde

udevadm trigger || true
udevadm settle || true
if lsblk -lf -o NAME,FSTYPE | grep -q ntfs; then
    for i in $(lsblk -lf -o NAME,FSTYPE | awk '/ntfs/{print $1}'); do ntfs-3g.probe --readwrite /dev/"$i" || true; done &> /tmp/fastboot

    # prüfe, ob Windows per Bitlocker vberschlüsselt wurde
    if lsblk -lf -o NAME,FSTYPE | grep -iq bitlock; then
	lsblk -lf -o NAME,FSTYPE | grep -i bitlock | awk '{print $1}' &> /tmp/bitlock
    fi
fi
#some hacks
# stoppe Packagekit und den Discover Notifier
systemctl stop packagekit.service
if ps aux | grep -q DiscoverNotifier | grep -v grep; then
    killall -9 DiscoverNotifier
fi
# für die Zukunft, falls wir sddm mal auf Wayland umstellen wollen
#cp -f /usr/share/tuxedo/oem-conf/main.py /usr/lib/x86_64-linux-gnu/calamares/modules/session
#end some hacks


# Verzeichnis für die lokalisierten Text-Variablen
# /usr/share/tuxedo/oem-conf/

DEFLOCDIR=/usr/share/tuxedo/oem-conf/

llang=$(echo "$LANG" | awk -F\_ '{print $1}')

case "$llang" in
    de*)
	. "$DEFLOCDIR"/text_de
        ;;
    *)
	. "$DEFLOCDIR"/text_en
	export LANG=C
        ;;
esac


check_memory() {
    # Prüfe, wieviel Ram im System steckt und schreibe das Ergebnis in 
    # mem_g = Speciher in GiB + 1 (für swap mit hibernate)
    # mem_d = minimale Größer der Partition für TxOS (16 GiB) + Swap (Wenn Swap für hibernate benutzt werden soll)
    mem=$(LANG=C free -m | awk '/Mem/{ print $2 }')
    mem_g=$(echo "$mem/1024+1" | bc)
    mem_d=$(echo "$mem_g+16" | bc)
}

check_fastboot() {
    if [ -f /tmp/fastboot ]; then
        if [ "$(awk '/hibernate/{print $1}' /tmp/fastboot)" ]; then
	    fastboot=fastboot
	    echo "Fastboot gefunden"
	else
    	    fastboot=""
	    echo "Kein Fastboot"
	fi
    fi
}

check_bitlock() {
    if [ -f /tmp/bitlock ]; then
	if [ "$(cat /tmp/bitlock)" ]; then
    	    bitlock=lock
	    echo "Bitlocker gefunden"
	else
    	    bitlock=""
	    echo "Kein Bitlocker"
	fi
    fi
}

check_crypt() {
    # Dialog, ob geführte verschlüsselte Installation erfolgen soll
    set +e
    kdialog --title "$title2" --yesnocancel "<p>$text_cr1</p>" "<p>$text_crd1${mem_d}$text_crd2</p>" --yes-label "$cr_ja" --no-label "$cr_nein"
    dialog_exit=$?
    set -e
    case $dialog_exit in
	0)
	    echo "crypt"
	    ;;
	1)
	    set +e
	    calamares
	    exit 0
	    ;;
	*)
	    exit 0
	    ;;
    esac
}

check_efi() {
    # Prüfe, ob das System im EFI Mode läuft
    if [[ -e /sys/firmware/efi ]]; then
	efi="efi"
    else
	set +e
	calamares
        exit 0
    fi
}

find_device() {
    udevadm trigger || true
    udevadm settle || true
    mount | grep '^/dev/' | awk '{print $1}' | sed 's/^\/dev\///; s/\([0-9]*\|p[0-9]*\)$//' | sort -u > /tmp/mounts
    # erzeuge eine Liste von devices die kleiner als 16 GB sind
    if lsblk -ldb -o NAME,SIZE | awk '$2 <= 16000000000 {print $1}'; then
	lsblk -ldb -o NAME,SIZE | awk '$2 <= 16000000000 {print $1}' > /tmp/sizes
    else
	echo "foobar" > /tmp/sizes
    fi
    if lsblk -lf -o NAME,TYPE,SUBSYSTEMS,SIZE,LABEL | grep -iq ventoy; then
	lsblk -lf -o NAME,TYPE,SUBSYSTEMS,SIZE,LABEL | grep -i ventoy | awk '{print $1}' | sed 's/[0-9]*$//' > /tmp/ventoy
    else
	echo "foobar" > /tmp/ventoy
    fi
    # Üperprüfe, wieviele Platten im System stecken und präsentiere eine Auflistung der Platten, welche mindestens 16 GB Groß sind in Kdialog, wenn mehr als eine Festplatte im System steckt
    # erzeuge eine formatierte Liste der Festplatten
    for i in $(lsblk -dn -o NAME,SIZE,TYPE,SUBSYSTEMS | grep -vf "/tmp/mounts" | grep -vf "/tmp/sizes" | grep -vf "/tmp/ventoy" | grep -E -iv "loop|rom|0B" | awk '{print$1}'); do
        z=$(lsblk -dn -o NAME,Size | grep "$i" | awk '{print $2}')
        echo -e "$i"'\t'\'"$i"'\t'"$z"'\t'"$(sed 's/*_//' /sys/block/"$i"/device/model)"\' | sed "s/\ '/\'/g"
    done 1> /tmp/device1 2> /dev/null
    sort /tmp/device1 > /tmp/device 2> /dev/null
    if [[ "$(wc -l < /tmp/device)" -ge 2 ]]; then
        # Wenn Platte > 1, präsentiere eine Liste der verfügbaren Platten
        device=$(dialog_disk.pl)
    else
        device=$(awk '{print $1}' < /tmp/device)
    fi
    if [[ -z "$device" ]]; then
        kdialog --sorry "$text1"
        exit 0
    fi
    echo "$device" > /root/disk
    rm -f /tmp/mounts
    rm -f /tmp/sizes
    rm -f /tmp/ventoy
}

#find_biggest() {
#    disk="/dev/${device}"
#    lsblk_output=$(lsblk -lbno NAME,SIZE "$disk" | tail -n +2)
#
#    largest_partition=""
#    largest_size=0
#
#    # Schleife durch die Partitionen und finde die größte
#    while read -r partition size; do
#        size_in_bytes=$((size))
#        if ((size_in_bytes > largest_size)); then
#            largest_size=$size_in_bytes
#            largest_partition=$partition
#        fi
#    done <<< "$lsblk_output"
#
#    # Ausgabe der größten Partition
#    echo "Die größte Partition: $largest_partition"
#    number="${largest_partition: -1}"
#}

# Finde heraus, ob es einen unpartitionieren Bereich von mind. 16000 MiB gibt.
check_free() {
    udevadm trigger || true
    udevadm settle || true
    if ! parted -s /dev/"$device" print >/dev/null 2>&1; then
	no_table="1"
        # Keine Partitionstabelle vorhanden → gesamte Platte frei
        size_bytes=$(blockdev --getsize64 /dev/"$device")   # Bytes
        size=$((size_bytes / 1024 / 1024))                  # in MiB
        echo "INFO: Keine Partitionstabelle gefunden – gesamte Platte frei (${size} MiB)."
    else
	no_table="0"
	size=$(LANG=C parted /dev/"$device" unit MiB print free | grep Free | awk '{print $3}' | sort | tail -1 | awk -F, '{print $1}' | awk -F. '{print $1}' | sed 's/MiB//')
	if [[ -z "$size" ]]; then
	    echo "WARNUNG: Kein freier Speicher erkannt. Setze 0."
	    size=0
	fi
    fi
    if [ "$size" -ge 16000 ]; then
	if [ "$no_table" = "1" ]; then
	    space="$size"
	    echo "$space"
	    echo "Genug Platz"
	else
	    space=$(LANG=C parted /dev/"$device" unit MiB print free | grep Free | awk '{print $3}' | sort | tail -1 | sed 's/MiB//')
	    spaceg=$(echo "${space}/1024" | bc)
	    min_size=$(echo "${spaceg}+16" | bc)
	    echo "$space"
	    echo "Genug Platz"
	fi
    else
	echo "Kein Platz"
        space=""
    fi
}

# Generiere nutzbare Partitionsnummern für parted, auch bei lükenhafter Partitionstabelle
count_part() {
    udevadm trigger || true
    udevadm settle || true
    parts=$(LANG=C blkid -c /dev/null | grep "$device" | awk -F\: '{print $1}' | sort | wc -l 2>/dev/null)
    # 1. Alle Partitionsnummern extrahieren und in ein Array speichern (statt einer Datei)
    mapfile -t existing_parts < <(parted /dev/"$device" print | awk '/^ [0-9]+/ {print $1}')

    # 2. Anzahl der vorhandenen Partitionen ermitteln
    num_existing_parts=${#existing_parts[@]}

    # 3. Erwartete Gesamtanzahl (vorhandene + 3)
    expected_total=$((num_existing_parts + 3))

    # 4. Fehlende Partitionen finden
    missing_parts=()
    for i in $(seq 1 "$expected_total"); do
        found=false
        for part in "${existing_parts[@]}"; do
            if [[ "$part" -eq "$i" ]]; then
                found=true
                break
            fi
        done
        if [[ "$found" == false ]]; then
            missing_parts+=("$i")
        fi
    done

    # 5. Fehlende Partitionen in Variablen speichern (sicherstellen, dass genug Werte vorhanden sind)
    pnum1=${missing_parts[0]:-N/A}
    pnum2=${missing_parts[1]:-N/A}
    pnum3=${missing_parts[2]:-N/A}

    # Ausgabe zur Kontrolle
    echo "Fehlende Partitionen:"
    echo "partnum1: $pnum1"
    echo "partnum2: $pnum2"
    echo "partnum3: $pnum3"
}

size_fd() {
    # erzeugt die Werte der Partitionsgrößen, wie sie durch den Installer erzeugt werden, 
    # dient zur Anzeige in Kdialog, damit der User sieht, wie die Paritionieren erfolgen soll
    #crypt_part_size=$(parted /dev/"$device" unit MiB print | grep "${device}" | awk '{print $3}' | sed 's/MiB//')
    crypt_part_size=$size
    crypt_part_sizem=$(echo "${crypt_part_size}-2562" | bc)
    crypt_part_sizeg=$(echo "${crypt_part_sizem}/1024" | bc)
    root_part_size=$(echo "${crypt_part_sizeg}" | bc)
    pnum1="1"
    pnum2="2"
    pnum3="3"
}

# erzeuge die Start- und Endwerte der benötigten 3 Partitionen, sowie die Größe selbiger für parted
generate_sizes() {
    #find_biggest
    endd=$(LANG=C parted /dev/"$device" unit MiB print free | awk '/Disk/{print $3}' | sed 's/MiB//')
    endp=$(LANG=C parted /dev/"$device" unit MiB print free | grep MiB | grep -v Disk | grep "$space" | awk '{print $2}' | sed 's/MiB//')
    start=$(LANG=C parted /dev/"$device" unit MiB print free | grep MiB | grep -v Disk | grep "$space" | awk '{print $1}' | sed 's/MiB//')
    if [ "$endd" = "$endp" ]; then
	end="100%"
    else
	end="$endp"
    fi
    start1=$(echo "${start}+1" | bc)
    start2=$(echo "${start1}+2048" | bc)
    start3=$(echo "${start2}+512" | bc)
    crypt_part_sizem=$(echo "${space}-2562" | bc)
    crypt_part_sizeg=$(echo "${crypt_part_sizem}/1024" | bc)
    root_part_size=$(echo "${crypt_part_sizeg}" | bc)
}

luks_passwd() {
    # Abfrage für das gewünschte LUKS Passwort
    ERC=1
    until [[ "$ERC" -ne 1 ]]
    do
    if ! CPASSW1=$(kdialog --title="$title_pw" --password "$text_pw1" 2>/dev/null); then
        kdialog --error "$text_pw4" 2>/dev/null
        exit 0;
    fi
    if ! CPASSW2=$(kdialog --title="$title_pw" --password "$text_pw2" 2>/dev/null); then
        kdialog --error "$text_pw4" 2>/dev/null
        exit 0;
    fi
    sleep 1
    if [[ "$CPASSW1" == "$CPASSW2" ]]; then
        set +H
        ERC=0
        lukspw="$CPASSW1"
        break;
    else
        ERC=1
        kdialog --error "$text_pw3" 2>/dev/null
    fi
    done
}

prepare_disk_full() {
    pnum1=1
    pnum2=2
    pnum3=3
    # geskriptete Partitionierung der ausgewählten Platte, ganze Platte wird benutzt.
    # nvme=$(echo "$device" | grep nvm)
    if echo $device | grep -q nvm; then
        part="p"
    else
        part=""
    fi
    parted --script /dev/"$device" \
          mklabel gpt \
          mkpart primary ext3 1MiB 2049MiB \
          mkpart primary fat32 2049MiB 2561MiB \
          mkpart primary 2561MiB 100% \
          name "${pnum1}" BOOT \
          name "${pnum2}" EFI \
          name "${pnum3}" CRYPT \
          set "${pnum2}" esp on \
          print \
          quit

    echo "$lukspw" | cryptsetup -q luksFormat /dev/"$device""$part""$pnum3"
    echo "$lukspw" | cryptsetup -q luksOpen /dev/"$device""$part""$pnum3" crypt_dev_"$device""$part""$pnum3"
    pvcreate /dev/mapper/crypt_dev_"$device""$part""$pnum3"
    vgcreate system /dev/mapper/crypt_dev_"$device""$part""$pnum3"
    lvcreate -n root -l 100%FREE system
    echo "$device""$part""$pnum1" > /root/boot
    echo "$device""$part""$pnum2" > /root/efi
    echo "$device""$part""$pnum3" > /root/crypt
    mkfs."$fs" /dev/system/root
    mkfs.ext3 /dev/"$device""$part""$pnum1" -L BOOT<<EOF
y
EOF
    mkfs.vfat /dev/"$device""$part""$pnum2" -n EFI
}

prepare_disk_along() {
    # geskriptete Partitionierung der ausgewählten Platte, parallel zu vorhandenem OS
    count_part
    generate_sizes
    #nvme=$(echo "$device" | grep nvm)
    if echo $device | grep -q nvm; then
        part="p"
    else
        part=""
    fi
    parted --script /dev/"$device" \
         mkpart primary ext3 "$start1"MiB "$start2"MiB \
         mkpart primary fat32 "$start2"MiB "$start3"MiB \
         mkpart primary "$start3"MiB "$end"MiB \
         name "$pnum1" BOOT \
         name "$pnum2" EFI \
         name "$pnum3" CRYPT \
         set "$pnum2" esp on \
         print \
         quit

    echo "$lukspw" | cryptsetup -q luksFormat /dev/"$device""$part""$pnum3"
    echo "$lukspw" | cryptsetup -q luksOpen /dev/"$device""$part""$pnum3" crypt_dev_"$device""$part""$pnum3"
    pvcreate /dev/mapper/crypt_dev_"$device""$part""$pnum3"
    vgcreate system /dev/mapper/crypt_dev_"$device""$part""$pnum3"
    lvcreate -n root -l 100%FREE system
    echo "$device""$part""$pnum1" > /root/boot
    echo "$device""$part""$pnum2" > /root/efi
    echo "$device""$part""$pnum3" > /root/crypt
    mkfs."$fs" /dev/system/root
    mkfs.ext3 /dev/"$device""$part""$pnum1" -L BOOT<<EOF
y
EOF
    mkfs.vfat /dev/"$device""$part""$pnum2" -n EFI
}

use_full() {
    # Hinweis für den User, dass alle Daten gelöscht werden
    # in den Details wird die aktuelle Partitionierung der gewählten Platte angezeigt
    udevadm trigger || true
    udevadm settle || true
    disk=$(lsblk -d -o NAME,MODEL,ID-LINK | grep "$device" | sed 's/^\([^ ]*\) \(.*\)$/\2/' | sed 's/^[[:space:]]*//')
    lsblk -ln -o NAME,SIZE,FSTYPE | grep "$device" | awk 'BEGIN { printf "%-18s %-18s %-18s\n", "NAME", "SIZE", "Filesystem" }{ printf "%-18s %-18s %-18s\n", $1, $2, ($3 ? $3 : "-") }' > /tmp/detail.txt
    set +e
    kdialog --title "$title_fd" --yesnocancel "$text_fd<pre>								\n	$disk\n\n$(cat /tmp/detail.txt)\n\n</pre>" --yes-label "$pn" --no-label "$nein2"
    dialog_exit=$?
    set -e
    case $dialog_exit in
	0)
	    fd_install="1"
	    parts=0
	    ;;
	1)
	    if [ "$no_table" = "1" ]; then 
		fd_install="1"
		parts=0
	    else
		fd_install="0"
	    fi
	    ;;
	*)
	    exit 0
	    ;;
    esac
}

rsync_task() {
    # kopiert das Live-System auf die vorbereiteten und gemounteten Partitionen
    rsync -aAXv / --exclude={"/dev/*","/proc/*","/sys/*","/tmp/*","/run/*","/mnt/*","/media/*","/lost+found","/boot/efi","/fll"} /mnt
}

check_mounts() {
    # Prüfe, ob alle notwendigen Partitionen gemountet sind
    mounted=$(mount | grep "system-root" | awk '{print $5}' 2>/dev/null)
    if [[ -z "${mounted}" ]]; then
        kdialog --error "$text_mount" 2>/dev/null
        exit 1
    fi
}

prepare_target() {
    # mountet die notwendigen Partitione, bevor der Rsync-Task startet
    #nvme=$(echo "$device" | grep nvm)
    if echo $device | grep -q nvm; then
        part="p"
    else
        part=""
    fi
    if [[ "$fs" = btrfs ]]; then
	mount -t "$fs" /dev/system/root /mnt -o defaults,noatime,space_cache=v2,autodefrag,compress=zstd:1
	btrfs subvolume create /mnt/@
	btrfs subvolume create /mnt/@home
	umount -R /mnt
	mount -t "$fs" /dev/system/root /mnt -o defaults,subvol=@,noatime,space_cache=v2,autodefrag,compress=zstd:1
	mkdir -p /mnt/home
	mount -t "$fs" /dev/system/root /mnt/home -o defaults,subvol=@home,noatime,space_cache=v2,autodefrag,compress=zstd:1
    else
	mount -t "$fs" /dev/system/root /mnt
    fi
    mkdir -p /mnt/boot
    mount /dev/"$device""$part""$pnum1" /mnt/boot
}

calamares_task() {
    # startet ein Mini-Variante des Calamares direkt aus dem eben kopierten System per chroot
    #nvme=$(echo "$device" | grep nvm)
    if echo $device | grep -q nvm; then
        part="p"
    else
        part=""
    fi
    mkdir -p /mnt/boot/efi
    mount /dev/"$device""$part""$pnum2" /mnt/boot/efi
    for d in /dev /dev/pts /proc /sys /sys/firmware/efi/efivars /run; do sudo mount -B "$d" /mnt"$d"; done
    chroot /mnt rm -r /etc/calamares
    chroot /mnt ln -s /usr/share/tuxedo/calamares-oem /etc/calamares
    chroot /mnt calamares
}

finished_task() {
    # Fragt nach, ob $User nach der Installation rebooten will, oder noch weiter in der Live-Session gucken will.
    if kdialog --title "$title_finish" --yesno "<p align="center">$text_finish</p>" 2>/dev/null
        then
        systemctl reboot
    else
	umount -R /mnt
	sleep 1
        vgchange -a n system
        cryptsetup luksClose crypt_dev_"$device""$part""$pnum3"
        exit
    fi
}
info_1() {
    # Zeigt dem User, wie die Partitionierung des neuen Systems aussehen wird und hier kann der User auch das FS von ext4 (Standard) auf btrfs oder xfs umstellen
    length1=${#crypt_part_sizeg}
    length2=${#root_part_size}
    space1=""
    if [[ "$length1" -eq 2 ]]; then
	space1=" "
    elif [[ "$length1" -eq 3 ]]; then
	space1="  "
    elif [[ "$length1" -eq 4 ]]; then
	space1="   "
    fi
    if [[ "$length2" -eq 2 ]]; then
	space2=" "
    elif [[ "$length2" -eq 3 ]]; then
	space2="  "
    elif [[ "$length2" -eq 4 ]]; then
	space2="   "
    fi
    #nvme=$(echo "$device" | grep nvm)
    if echo $device | grep -q nvm; then
        part="p"
    else
        part=""
    fi
    if [[ "$llang" = de ]]; then
	fs=ext4
	set +e
	kdialog --title "Partitionen" --yesnocancel "<pre>Die folgenden Partitionen werden auf /dev/${device} erzeugt:	\n\n${device}${part}${pnum1}:		${space1}2.0	GB	 Boot \n${device}${part}${pnum2}:		${space1}0.5	GB	  EFI \n${device}${part}${pnum3}:		${crypt_part_sizeg}.0	GB	LUKS2 \n |\n |-system-root	${root_part_size}.0	GB	 ext4\n\nDie Systempartition wird standardmäßig mit ext4 formatiert.\nWenn sie das nicht möchten, wählen Sie 'Filesystem ändern'.\n\n</pre>" --yes-label "Akzeptieren und Weiter " --no-label "Dateisytem ändern"
	dialog_exit=$?
	set -e
	case $dialog_exit in
	    0)
		echo ""
		;;
	    1)
		set +e
		fs=$(kdialog --combobox "Wählen Sie hier das Filesystem für die Systempartition." ext4 btrfs xfs --default ext4 --title "Filesystem")
		dialog_exit=$?
		set -e
		case $dialog_exit in
		    0)
			echo ""
			;;
		    *)
			kdialog --sorry "Nichts gewählt, beende." --title "Fehler" 
			exit 0
			;;
		esac
		;;
	    *)
		exit 0
		;;
	esac
    else
	fs=ext4
	set +e
	kdialog --title "Partitions" --yesnocancel "<pre>The following partitions will be created on /dev/${device}:	\n\n${device}${part}${pnum1}:		${space1}2.0	GB	 Boot \n${device}${part}${pnum2}:		${space1}0.5	GB	  EFI \n${device}${part}${pnum3}:		${crypt_part_sizeg}.0	GB	LUKS2 \n |\n |-system-root	${root_part_size}.0	GB	 ext4\n\\nThe system partition is formatted with ext4 by default.\nIf you prefer a different filesystem, choose another option \nin the next dialog.\n\n</pre>" --yes-label "Accept and continue" --no-label "Change filesystem"
	dialog_exit=$?
	set -e
	case $dialog_exit in
	    0)
		echo ""
		;;
	    1)
		set +e
		fs=$(kdialog --combobox "Select the file system for the system partition here." btrfs ext4 xfs --default btrfs --title "Filesystem")
		dialog_exit=$?
		case $dialog_exit in
		    0)
			echo ""
			;;
		    *)
			kdialog --sorry "Nothing selected, quit." --title "Error"
			exit 0
			;;
		esac
		;;
	    *)
		exit 0
		;;
	esac
    fi
}

echo "check_memory"
check_memory >> "$logfile"
echo "check_efi"
check_efi >> "$logfile"
echo "check_crypt"
check_crypt >> "$logfile"
echo "find_device"
find_device >> "$logfile"
echo "check_free"
check_free >> "$logfile"
echo "check_fastboot"
check_fastboot >> "$logfile"
echo "check_bitlock"
check_bitlock >> "$logfile"
echo "use_full"
use_full >> "$logfile"
#set -x
#if [ "$space" ]; then
#    echo "generate_sizes"
#    generate_sizes >> "$logfile"
#fi
if [[ "$fd_install" = 1 ]];then
    echo "size_fd"
    size_fd >> "$logfile"
    echo "info_1"
    info_1 
    luks_passwd
    echo "prepare_disk_full"
    prepare_disk_full | tee -a "$logfile" | zenity --progress --title="$title_part_zenity" --pulsate --no-cancel --width=400 --auto-close
else
    count_part >> "$logfile"
    if [ "$bitlock" ] && [ ! "$space" ]; then
        kdialog --title "$title_bitlock" --sorry "$text_bitlock" 2>/dev/null
        exit 0
    fi
    if [ "$fastboot" ] && [ ! "$space" ]; then
        kdialog --title "Problem!" --sorry "$text_fastboot" 2>/dev/null
        exit 0
    fi
    if [ ! "$space" ] && [ "$parts" ]; then
        echo "Platz? " "$space"
        echo "Partitionen? " "$parts"
	set +e
        kdialog --title "$title_nspace" --warningyesno "$text_nspace1/dev/""${device}"" $text_nspace2$text_nspace3" --yes-label "$pj" 2>/dev/null
	dialog_exit=$?
	set -e
        case $dialog_exit in
            0)
                gparted /dev/"$device" 2>/dev/null
                check_free >> "$logfile"
                generate_sizes >> "$logfile"
                count_part >> "$logfile"
                if [ -z "$space" ]; then
                    kdialog --title "$title_npart" --msgbox "$text_npart" 2>/dev/null
            	    exit 0
                fi
                ;;
            *)
                kdialog --title "$title_npart" --msgbox "$text_npart" --ok-label "$ok1" 2>/dev/null
                exit 0
                ;;
        esac
    fi
    generate_sizes >> "$logfile"
    info_1
    luks_passwd
    prepare_disk_along | tee -a "$logfile" | zenity --progress --title="$title_part_zenity" --pulsate --no-cancel --width=400 --auto-close
fi

prepare_target >> "$logfile"
check_mounts >> "$logfile"
rsync_task  | zenity --progress --title="$title_rsync_zenity" --text="$text_rsync_zenity" --pulsate --no-cancel --width=400 --auto-close
set +e
calamares_task >> "$logfile"
finished_task >> "$logfile"
